/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.utils.Array;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.model.BinaryGrid;

public class OreVeinGenerator {
    public BinaryGrid generate(int length, float inputThickness, float variance, Random random) {
        Array<Integer> thicknesses = new Array<Integer>(length);
        int actualMaxThickness = 0;
        for (int cursor = 0; cursor < length; ++cursor) {
            float distanceToCenter = Math.abs((float)cursor - (float)length / 2.0f);
            float normalisedDistanceToCenter = distanceToCenter / ((float)length / 2.0f);
            float normalisedNearnessToCenter = 1.0f - normalisedDistanceToCenter;
            float thickness = normalisedNearnessToCenter * inputThickness + (random.nextFloat() * 2.0f - 1.0f) * variance;
            int actualThickness = Math.max(1, Math.round(Math.abs(thickness)));
            if (actualThickness > actualMaxThickness) {
                actualMaxThickness = actualThickness;
            }
            thicknesses.add(actualThickness);
        }
        Array<Array<Boolean>> xArray = new Array<Array<Boolean>>(length);
        for (int columnCursor = 0; columnCursor < length; ++columnCursor) {
            Array<Boolean> yArray = new Array<Boolean>(actualMaxThickness);
            Integer thicknessToProduce = (Integer)thicknesses.get(columnCursor);
            int blanksToAdd = actualMaxThickness - thicknessToProduce;
            int blanksToAddBefore = blanksToAdd / 2;
            if (blanksToAdd % 2 == 1 && random.nextBoolean()) {
                ++blanksToAddBefore;
            }
            for (int cellCursor = 0; cellCursor < actualMaxThickness; ++cellCursor) {
                if (cellCursor < blanksToAddBefore) {
                    yArray.add(false);
                    continue;
                }
                if (cellCursor < blanksToAddBefore + thicknessToProduce) {
                    yArray.add(true);
                    continue;
                }
                yArray.add(false);
            }
            xArray.add(yArray);
        }
        BinaryGrid grid = new BinaryGrid(xArray);
        float amountToSkewBy = random.nextFloat() * (float)length;
        grid.skew(amountToSkewBy);
        for (int numTimeToRotate = random.nextInt(3); numTimeToRotate > 0; --numTimeToRotate) {
            grid.rotate90();
        }
        return grid;
    }
}

